@extends('layouts.invoice')

@section('content')
<section>
	<div class="card elevation-0 mb-0">
		<div class="card-body p-0">
			<div class="row">
				<div class="col-12">
					<div class="table-responsive">
						<table class="table table-bordered table-striped mb-0">
							<thead>
								<tr>
									<th class="nowrap">{{ __('reports.th_name') }}</th>
									<th>{{ __('reports.th_amount') }}</th>
									<th>{{ __('reports.th_payment_date') }}</th>
									<th class="nowrap">{{ __('reports.th_transaction_type') }}</th>
									<th class="nowrap">{{ __('reports.th_payment_method') }}</th>
									<th class="fixed-width-td">{{ __('reports.th_details') }}</th>

								</tr>
							</thead>
							<tbody>
								@foreach($payments as $payment)
								<tr>
									<td class="align-middle nowrap">{{ transaction_name($payment) }}</td>
									<td class="align-middle">{!! transaction_type($payment) !!}</td>
									<td class="align-middle nowrap">{{ format_date($payment->date) }}</td>
									<td class="align-middle nowrap">{{ $payment->type }}</td>
									<td class="align-middle nowrap">{{ $payment->method }}</td>
									<td class="align-middle nowrap">{{ $payment->note }}</td>
								</tr>
								@endforeach

								@if(count($payments) == 0)
								<tr>
									<td colspan="11">
										<p class="text-center text-muted mb-0">No Record Found</p>
									</td>
								</tr>
								@endif
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection

@section('js-script')
<script>
	window.addEventListener("load", window.print());
</script>
@endsection